chrome.runtime.onInstalled.addListener(() => {
    chrome.contextMenus.create({
        id: "openInJWVideoPlayer",
        title: "Open in JW Video Player",
        contexts: ["link"],
        documentUrlPatterns: ["*://*.jw.org/*", "*://*.wol.jw.org/*"]
    });
});

chrome.contextMenus.onClicked.addListener((info, tab) => {
    if (info.menuItemId === "openInJWVideoPlayer") {
        const encodedUrl = encodeURIComponent(info.linkUrl);
        chrome.tabs.create({
            url: `https://v.jw-net.work/?url=${encodedUrl}`
        });
    }
});